package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@NoArgsConstructor
@Table(name = "t_mbr_order_payment")
public class OrderPaymentModel extends BaseModel implements Serializable {


    @Id
    @ApiModelProperty(value = "支付详情主键", name = "mbrOrderPaymentId", example = "支付详情主键")
    private Long mbrOrderPaymentId;

    @ApiModelProperty(value = "所属会员", name = "memberCode", example = "所属会员")
    private String memberCode;

    @ApiModelProperty(value = "所属企业id", name = "sysCompanyId", example = "所属企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId", example = "品牌id")
    private Long brandId;

    @ApiModelProperty(value = "订单号", name = "orderNo", example = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "支付金额", name = "payAmount", example = "支付金额")
    private BigDecimal payAmount;

    @ApiModelProperty(value = "支付类型", name = "payTypeId", example = "支付类型")
    private String payTypeId;

    @ApiModelProperty(value = "支付单号", name = "payNumber", example = "支付单号")
    private String payNumber;

    @ApiModelProperty(value = "支付类型/方式名称",name = "payName")
    private String payName;

    @ApiModelProperty(value = "使用积分",name = "integralUsed")
    private Integer integralUsed;

    @ApiModelProperty(value = "积分类型 0减积分 1加积分",name = "integralType")
    private Integer integralType;

    @ApiModelProperty(value = "支付使用的优惠券号",name = "couponCode")
    private String couponCode;

}
