package com.bizvane.members.facade.service.Icrm;

import com.bizvane.members.facade.vo.MbrIcrmInfoVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}/members")
public interface MbrGetIcrmInfoService {

    @RequestMapping(value = "/getMbrInfo", method = RequestMethod.POST)
    ResponseData<MbrIcrmInfoVo> getIcrmMbrInfo(@RequestBody String jsonStr, Long corpId);

    /**
     * 根据参数获取会员信息
     *
     * @param jsonStr 传入参数
     * @param corpId  公司ID
     * @return ResponseData<MbrIcrmInfoVo>
     */
    @RequestMapping(value = "/getMbrInfoByParam", method = RequestMethod.POST)
    ResponseData<MbrIcrmInfoVo> getMbrInfoByParam(@RequestParam(value = "jsonStr") String jsonStr, @RequestParam(value = "corpId") Long corpId);
}
