package com.bizvane.members.facade.service.datafetch.model;

import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liufq
 */
public class MemberBalanceModel extends BaseFetchModel implements Serializable {
    @ApiModelProperty(value = "余额", name = "balance", example = "1.0")
    private BigDecimal balance;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date offlineUpdateBalanceDate;

    @ApiModelProperty(value = "储值卡号", name = "petCard")
    private String petCard;

    @ApiModelProperty(value = "运营组织Code", name = "organizationCode")
    private String organizationCode;

    public String getPetCard() {
        return petCard;
    }

    public void setPetCard(String petCard) {
        this.petCard = petCard;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public Date getOfflineUpdateBalanceDate() {
        return offlineUpdateBalanceDate;
    }

    public void setOfflineUpdateBalanceDate(Date offlineUpdateBalanceDate) {
        this.offlineUpdateBalanceDate = offlineUpdateBalanceDate;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }
}