package com.bizvane.members.facade.service.card;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.service.card.request.UpdateMemberPhoneRequestModel;
import com.bizvane.members.facade.service.card.response.UpdateMemberPhoneResponseModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/24.
 */
@Slf4j
public abstract class AbstractApiUpdateMemberPhoneService {

    public abstract void validationData(UpdateMemberPhoneRequestModel updateMemberPhoneRequestModel);

    public abstract UpdateMemberPhoneResponseModel syncSendPhoneToOffline(UpdateMemberPhoneRequestModel updateMemberPhoneRequestModel);

    public abstract UpdateMemberPhoneResponseModel updateOnlineMemberPhone(UpdateMemberPhoneRequestModel updateMemberPhoneRequestModel);

    @Transactional(rollbackFor = Exception.class)
    public UpdateMemberPhoneResponseModel updatePhone(UpdateMemberPhoneRequestModel updateMemberPhoneRequestModel){
        //验证数据有效性
        this.validationData(updateMemberPhoneRequestModel);

        UpdateMemberPhoneResponseModel updateMemberPhoneResponseModel = null;

        //更新线上手机号
        try{
            updateMemberPhoneResponseModel = this.updateOnlineMemberPhone(updateMemberPhoneRequestModel);
        }catch(MemberException me){
            log.error(me.getMessage());
            me.getStackTrace();
            updateMemberPhoneResponseModel = new UpdateMemberPhoneResponseModel();
            updateMemberPhoneResponseModel.setCode(SysResponseEnum.FAILED.getCode());
            updateMemberPhoneResponseModel.setMessage("修改失败");
        }
        //如果线上成功更新线下手机号
        if(updateMemberPhoneResponseModel.getCode() == SysResponseEnum.SUCCESS.getCode()){
            updateMemberPhoneResponseModel = this.syncSendPhoneToOffline(updateMemberPhoneRequestModel);
        }
        return updateMemberPhoneResponseModel;
    }
}
