package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.models.po.MbrTiktokOrderDetailPO;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


@Data
public class MbrTiktokOrderRsp implements Serializable {

    private Long mbrTiktokOrderId;
    private String merchantId;
    private String orderId;
    private String memberCode;
    private String cardNo;
    private String phone;
    private Date openCardTime;
    private Long openCardChannelId;
    private String openCardChannelName;
    private Long sysCompanyId;
    private Integer brandId;

    /**
     * Database Column Remarks:
     *   订单状态
     *
     *   （OrderStatus_Init 初始化 OrderStatus = 0
     *
     *   OrderStatus_WaitPay 待支付 OrderStatus = 100
     *
     *   OrderStatus_Cancel 订单关闭 OrderStatus = 101
     *
     *   OrderStatus_PaySuccess 支付成功 OrderStatus = 200
     *
     *   OrderStatus_Available 待使用 OrderStatus = 201
     *
     *   OrderStatus_Finish 交易成功 OrderStatus = 1
     *
     *   OrderStatus_PartPay 部分支付  OrderStatus = 150）
     *
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_mbr_tiktok_order.order_status
     *
     * @mbg.generated Fri Jun 20 18:09:25 CST 2025
     */
    private Integer orderStatus;
    private Date createOrderTime;
    private Date payTime;
    private BigDecimal payMoney;
    private String productId;
    private String productName;
    private Integer productCount;
    private Integer couponCount;
    private String onlineOrgCode;
    private String onlineOrgName;
    private String remark;
    private Long createUserId;
    private String createUserName;
    private Date createDate;
    private Long modifiedUserId;
    private String modifiedUserName;
    private Date modifiedDate;
    /**
     * 订单明细
     */
    private List<MbrTiktokOrderDetailPO> orderDetailList;

}