package com.bizvane.members.facade.es.vo;

import com.bizvane.members.facade.vo.PageVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;


@EqualsAndHashCode(callSuper = true)
@Data
public class MbrTiktokOrderReqVo extends PageVo {

    @ApiModelProperty(value = "订单号")
    private String orderId;

    @ApiModelProperty(value = "会员卡号")
    private String cardNo;

    private String phone;

    private Long sysCompanyId;

    private Integer brandId;

    /**
     *
     *   订单状态
     *   
     *   （OrderStatus_Init 初始化 OrderStatus = 0
     *   
     *   OrderStatus_WaitPay 待支付 OrderStatus = 100
     *   
     *   OrderStatus_Cancel 订单关闭 OrderStatus = 101
     *   
     *   OrderStatus_PaySuccess 支付成功 OrderStatus = 200
     *   
     *   OrderStatus_Available 待使用 OrderStatus = 201
     *   
     *   OrderStatus_Finish 交易成功 OrderStatus = 1
     *   
     *   OrderStatus_PartPay 部分支付  OrderStatus = 150）
     */
    @ApiModelProperty(value = "订单状态", notes = "OrderStatus_Init 初始化 OrderStatus = 0, OrderStatus_WaitPay 待支付 OrderStatus = 100, OrderStatus_Cancel 订单关闭 OrderStatus = 101, OrderStatus_PaySuccess 支付成功 OrderStatus = 200, OrderStatus_Available 待使用 OrderStatus = 201, OrderStatus_Finish 交易成功 OrderStatus = 1, OrderStatus_PartPay 部分支付  OrderStatus = 150")
    private Integer orderStatus;

    @ApiModelProperty(value = "支付时间开始")
    private Date payTimeStart;
    @ApiModelProperty(value = "支付时间结束")
    private Date payTimeEnd;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "运营组织")
    private String onlineOrgCode;

    @ApiModelProperty(value = "开卡时间开始")
    private Date openCardTimeStart;
    @ApiModelProperty(value = "开卡时间结束")
    private Date openCardTimeEnd;

}