package com.bizvane.members.facade.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 *  单个用户标签编辑
 * @author Lenovo
 */
@Data
public class LabelDefSyncReq {

    @NotEmpty
    private String brandCode;

    // 标签类型：1-导购标签，2-规则标签
    @NotEmpty
    private Integer labelType;

    private String groupCode;

    private String groupName;

    private String labelCode;

    @NotEmpty
    private String labelName;

    private List<String> valueList;

    // 是否允许导购贴、撕标签 0-不允许 1-允许（默认1）
    private Integer openStaff;

    // 操作类型：add添加，del删除，update更新（只支持更新标签名称）
    private String action;
}
