package com.bizvane.members.facade.enums;

import lombok.Getter;

/**
 * 抖音订单项状态枚举
 */
@Getter
public enum TiktokOrderItemStatusEnum {

    INIT(0L, "初始化"),
    FINISH(1L, "交易成功"),
    WAIT_PAY(10L, "待支付"),
    PART_PAY(15L, "部分支付"),
    PAY_SUCCESS(20L, "支付成功"),
    AVAILABLE(100L, "待使用"),
    CLOSE(101L, "交易关闭"),
    BOOKING(200L, "预约中"),
    BOOK_SUCCESS(201L, "已预约"),
    REFUNDING(300L, "退款中"),
    REFUND_SUCCESS(301L, "已退款"),
    FULFILLING(400L, "履约中"),
    FULFIL_SUCCESS(401L, "已履约");

    private final Long code;
    private final String desc;

    TiktokOrderItemStatusEnum(Long code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TiktokOrderItemStatusEnum getByCode(Long code) {
        if (code == null) {
            return null;
        }
        for (TiktokOrderItemStatusEnum status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public static boolean isValid(Long code) {
        return getByCode(code) != null;
    }
}