package com.bizvane.members.facade.models.third;

import com.bizvane.members.facade.models.MemberInfoModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ThirdMbrOpenCardBO implements Serializable {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public ThirdMbrOpenCardBO(MemberInfoModel memberInfoModel, String chainId, Boolean status, String failReason) {
		this.sysCompanyId = memberInfoModel.getSysCompanyId();
		this.sysBrandId = memberInfoModel.getBrandId();
		this.memberCode = memberInfoModel.getMemberCode();
		this.erpId = memberInfoModel.getErpId();
		this.cardNo = memberInfoModel.getCardNo();
		this.phone = memberInfoModel.getPhone();
		this.name = memberInfoModel.getName();
		this.openCardGuideCode = memberInfoModel.getOpenCardGuideCode();
		this.openCardGuideName = memberInfoModel.getOpenCardGuideName();
		this.openCardStoreCode = memberInfoModel.getOpenCardStoreCode();
		this.openCardStoreName = memberInfoModel.getOpenCardStoreName();
		this.openCardTime = memberInfoModel.getOpenCardTime();
		this.channelId = String.valueOf(memberInfoModel.getOpenCardChannelId());
		this.chainId = chainId;
		this.status = status;
		this.failReason = failReason;
	}

	public ThirdMbrOpenCardBO(Long sysCompanyId, Long sysBrandId, String memberCode, String erpId, String cardNo, String phone, String name, String openCardGuideCode, String openCardGuideName, String openCardStoreCode, String openCardStoreName, Date openCardTime, String channelId, String chainId, Boolean status, String failReason) {
		this.sysCompanyId = sysCompanyId;
		this.sysBrandId = sysBrandId;
		this.memberCode = memberCode;
		this.erpId = erpId;
		this.cardNo = cardNo;
		this.phone = phone;
		this.name = name;
		this.openCardGuideCode = openCardGuideCode;
		this.openCardGuideName = openCardGuideName;
		this.openCardStoreCode = openCardStoreCode;
		this.openCardStoreName = openCardStoreName;
		this.openCardTime = openCardTime;
		this.channelId = channelId;
		this.chainId = chainId;
		this.status = status;
		this.failReason = failReason;
	}

	public ThirdMbrOpenCardBO() {
	}

	@ApiModelProperty(value="企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value="品牌id")
    private Long sysBrandId;

    @ApiModelProperty(value="会员code")
    private String memberCode;

	@ApiModelProperty(value = "erpId", name = "erpId")
	private String erpId;

	@ApiModelProperty(value = "会员线上卡号", name = "cardNo")
	private String cardNo;

	@ApiModelProperty(value = "会员手机号", name = "phone")
	private String phone;

	@ApiModelProperty(value = "会员姓名", name = "name")
	private String name;

	@ApiModelProperty(name = "openCardGuideCode", value = "开卡导购code")
	private String openCardGuideCode;

	@ApiModelProperty(name = "openCardGuideName", value = "开卡导购名称")
	private String openCardGuideName;

	@ApiModelProperty(name = "openCardStoreCode", value = "开卡店铺code")
	private String openCardStoreCode;

	@ApiModelProperty(name = "openCardStoreCode", value = "开卡店铺名称")
	private String openCardStoreName;

	@ApiModelProperty(name = "openCardTime", value = "开卡时间")
	private Date openCardTime;

	@ApiModelProperty(value = "渠道：2-微信会员中心小程序、1-线下渠道、5-微信电子会员卡、3-支付宝会员中心小程序、4-天猫商城、6-商帆微商城、7-手工导入、8-微盟微商城、9-EHR、11-有赞微商城、12-南讯渠道、13-支付宝电子会员卡、14-商帆新微商城、15-官网、16-视频号小店", name = "channelId")
	private String channelId;

	@ApiModelProperty(name = "chainId", value = "触电id(UR上报神策专用)")
	private String chainId;

	private Boolean status;

	private String failReason;

}
