/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.utils;

import com.bizvane.members.facade.utils.CryptoCardNoPlugin;
import com.bizvane.members.facade.utils.PhoneEncryptConfig;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={String.class})
public class EncryptCardNoTypeHandler
extends BaseTypeHandler<String> {
    private static final Logger log = LoggerFactory.getLogger(EncryptCardNoTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        try {
            boolean needEncrypt;
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            Method localMethod = CryptoCardNoPlugin.getLocalMethod();
            if (localCompanyId == null) {
                log.error("encrypt phone brandId is null EncryptPhoneTypeHandler parameter: {}, method: {}", (Object)parameter, (Object)JacksonUtil.bean2Json((Object)localMethod));
            }
            if (needEncrypt = CryptoCardNoPlugin.needEncrypt()) {
                parameter = PhoneEncryptConfig.encryptAES(localCompanyId, parameter);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ps.setString(i, parameter);
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        try {
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            boolean needEncrypt = CryptoCardNoPlugin.needEncrypt();
            if (needEncrypt) {
                value = PhoneEncryptConfig.decryptAES(localCompanyId, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        try {
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            boolean needEncrypt = CryptoCardNoPlugin.needEncrypt();
            if (needEncrypt) {
                value = PhoneEncryptConfig.decryptAES(localCompanyId, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = cs.getString(columnIndex);
        try {
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            boolean needEncrypt = CryptoCardNoPlugin.needEncrypt();
            if (needEncrypt) {
                value = PhoneEncryptConfig.decryptAES(localCompanyId, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }
}

