package com.bizvane.members.facade.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 361会员查询返回Vo
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class MbrIcrmInfoVo {

    private String 	memberCode;

    private String 	name;

    private String 	phone;

    private String 	idCard;

    private String 	sex;

    private String 	birthday;

    private String 	province;

    private String 	city;

    private String 	county;

    private String 	levelName;

    private String 	levelCode;

    private String 	countIntegral;

    private String cardNo;

    private String erpId;

    @ApiModelProperty(value = "服务门店线下code", name = "serviceStoreCode", required = false, example = "服务门店线下code")
    private String serviceStoreCode;

    @ApiModelProperty(value = "服务导购线下code", name = "serviceGuideCode", required = false, example = "服务导购线下code")
    private String serviceGuideCode;

    @ApiModelProperty(value = "开卡店铺线下code", name = "openCardStoreCode", required = false, example = "开卡店铺线下code")
    private String openCardStoreCode;

    @ApiModelProperty(value = "开卡导购线下code", name = "openCardGuideCode", required = false, example = "开卡导购线下code")
    private String openCardGuideCode;

    @ApiModelProperty(value = "开卡时间", name = "openCardTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date openCardTime;

    @ApiModelProperty(value = "是否企业好友", name = "companyFriend")
    private Integer companyFriend;

    @ApiModelProperty(value = "线下等级code", name = "offlineLevelCode", required = false, example = "线下等级code")
    private String offlineLevelCode;
}
