package com.bizvane.members.facade.utils;

import com.bizvane.utils.redisutils.SpringContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Slf4j
public class PhoneEncryptConfig {

    public static String encryptAES(Long sysCompanyId, String data) {
        log.info("加密开始:{}", data);
        EncryptPhoneProperties properties = SpringContextHolder.getBean(EncryptPhoneProperties.class);
        if (StringUtils.isBlank(data)) {
            log.info("加密数据为空:");
            return data;
        }
        if (sysCompanyId == null || CollectionUtils.isNotEmpty(properties.getSysCompanyIdList())) {
            log.info("加密数据企业为空:{}", sysCompanyId);
            return data;
        }
        if (!properties.getSysCompanyIdList().contains(sysCompanyId)) {
            log.info("加密数据企业未开启:{}", sysCompanyId);
            return data;
        }

        try {
            return PhoneEncryptUtil.encryptAES(properties.getKey(), properties.getIv(), data);
        } catch (Exception e) {
            log.error("加密失败:", ExceptionUtils.getStackTrace(e));
        }
        return data;
    }

    public static String decryptAES(Long sysCompanyId, String data) {
        log.info("解密开始:{}", data);
        EncryptPhoneProperties properties = SpringContextHolder.getBean(EncryptPhoneProperties.class);

        if (StringUtils.isBlank(data)) {
            log.info("解密数据为空:");
            return data;
        }
        if (sysCompanyId == null || CollectionUtils.isNotEmpty(properties.getSysCompanyIdList())) {
            log.info("解密数据企业为空:{}", sysCompanyId);
            return data;
        }
        if (!properties.getSysCompanyIdList().contains(sysCompanyId)) {
            log.info("解密数据企业未开启:{}", sysCompanyId);
            return data;
        }
        try {
            return PhoneEncryptUtil.decryptAES(properties.getKey(), properties.getIv(), data);
        } catch (Exception e) {
            log.error("解密失败:", ExceptionUtils.getStackTrace(e));
        }

        return data;
    }
}