package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.vo.SysMaintenanceNoticeVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
@Api(value = "系统维护公告接口",tags = {"系统维护公告接口"})
public interface SysMaintenanceNoticeApiService {

    @ApiOperation(value = "新建系统维护公告")
    @RequestMapping(value = "/maintenanceNotice/addNotice", method = RequestMethod.POST)
    ResponseData addNotice(@RequestBody SysMaintenanceNoticeVo sysMaintenanceNoticeVo);

    @ApiOperation(value = "修改系统维护公告")
    @RequestMapping(value = "/maintenanceNotice/updateNotice", method = RequestMethod.POST)
    ResponseData updateNotice(@RequestBody SysMaintenanceNoticeVo sysMaintenanceNoticeVo);

    @ApiOperation(value = "查询系统维护公告")
    @RequestMapping(value = "/maintenanceNotice/selectNoticeByBrandId", method = RequestMethod.GET)
    ResponseData<SysMaintenanceNoticeVo> selectNoticeByBrandId(@RequestParam("brandId") Long brandId);
}