package com.bizvane.members.facade.models.bo;

import com.bizvane.members.facade.utils.EncryptPhone;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zcc
 * @date 2022/4/26 18:09
 **/
@Data
public class MemberOpenCardMutualValidationBo implements Serializable {

    private static final long serialVersionUID = -7349393249382297130L;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long brandId;

    @EncryptPhone
    @ApiModelProperty(value = "会员手机号", name = "phone")
    private String phone;

    @ApiModelProperty(value = "微信UnionId", name = "wxUnionId")
    private String wxUnionId;

    @ApiModelProperty(value = "会员code", name = "memberCode")
    private String memberCode;
}
