package com.bizvane.members.facade.service.common;

import com.bizvane.members.facade.models.MemberInfoUpdateResponseVO;
import com.bizvane.members.facade.models.StandardMemberPerfectRequestVo;
import com.bizvane.members.facade.models.po.MbrUniversalBindChannelPo;
import com.bizvane.members.facade.models.third.MemberThirdOpenCardRequestBO;
import com.bizvane.members.facade.vo.yanzhiwu.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface CommonMemberApiService {

    @PostMapping(value = "/api/yanzhiwu/openCard")
    ResponseData<MemberOpenCardResponseVo> openCard(@RequestBody @Valid MemberOpenCardRequestVo requestVo);
    
    @PostMapping(value = "/api/mbr/thirdOpenCard")
    ResponseData<MemberOpenCardResponseVo> thirdOpenCard(@RequestBody @Valid MemberThirdOpenCardRequestBO requestVo);

    @PostMapping(value = "/api/yanzhiwu/memberQuery")
    ResponseData<MemberQueryResponseVo> memberQuery(@RequestBody @Valid MemberQueryRequestVo requestVo);

    @PostMapping(value = "/api/yanzhiwu/memberPerfect")
    ResponseData<MemberInfoUpdateResponseVO> memberPerfect(@RequestBody @Valid StandardMemberPerfectRequestVo requestVo);

    @PostMapping(value = "/api/yanzhiwu/memberThirdBindChannel")
    ResponseData memberThirdBindChannel(@RequestBody @Valid MemberThirdBindChannelRequestVo requestVo);

    @PostMapping(value = "/api/yanzhiwu/memberUpdateChannelIds")
    ResponseData memberUpdateChannelIds(@RequestBody @Valid MemberUpdateChannelIdsReqVo requestVo);

    @PostMapping(value = "/api/yanzhiwu/queryMemberChannelRecord")
    ResponseData<Boolean> queryMemberChannelRecord(@RequestBody @Valid MemberQueryChannelRecordReqVo requestVo);
    
    @PostMapping(value = "/api/member/queryMbrUniversalBindChannel")
    ResponseData<MbrUniversalBindChannelPo> queryMbrUniversalBindChannel(@RequestBody @Valid MemberQueryChannelRecordReqVo requestVo);

    /**
     * 根据openId获取对应渠道的绑定记录
     * @param requestVO
     * @return
     */
    @PostMapping(value = "/api/member/selectMbrUniversalBindChannelByOpenId")
    ResponseData<List<MbrUniversalBindChannelPo>> selectMbrUniversalBindChannelByOpenId(@RequestBody @Valid ThirdChannelBindQueryRequestVO requestVO);

    /**
     * 删除会员注销未删除的渠道绑定记录
     * @param requestVO
     * @return
     */
    @PostMapping(value = "/api/member/deleteBindChannelByMemberCode")
    ResponseData<Boolean> deleteBindChannelByMemberCode(@RequestBody @Valid ThirdChannelDeleteRequestVO requestVO);


}
