package com.bizvane.members.facade.vo.qywx;

import com.bizvane.members.facade.enums.FriendsStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class UpdateFriendVo {

    @NotNull
    private Long sysCompanyId;

    @NotNull
    private Long guideId;

    private String externalUserId;

    private String unionId;

    @NotNull
    private FriendsStatusEnum friendsStatusEnum;

    @ApiModelProperty(value = "品牌ID", name = "sysBrandId")
    private Long sysBrandId;

    @ApiModelProperty(value = "官方标签ID字符串集合，以英文逗号分割", name = "officialLabelIds")
    private String officialLabelIds;

    @ApiModelProperty(value = "官方标签名称字符串集合，以英文逗号分割", name = "officialLabelNames")
    private String officialLabelNames;

    @ApiModelProperty(value = "自定义标签ID字符串集合，以英文逗号分割", name = "customLabelIds")
    private String customLabelIds;

    @ApiModelProperty(value = "自定义标签名称字符串集合，以英文逗号分割", name = "customLabelNames")
    private String customLabelNames;


}
