package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.enums.MemberCardStatusModifyActionEnum;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * @author zcc
 * @date 2021/8/2 16:48
 * 会员卡状态变更vo
 **/
@Data
public class MemberCardStatusModifyBaseVo implements Serializable {

    private static final long serialVersionUID = -8141370551703200857L;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long sysBrandId;

    /**
     * 会员membercode
     */
    @NotEmpty(message = "会员membercode不能为空", groups = MemberCardStatusModifyActionEnum.class)
    private String memberCode;

    /**
     * 操作类型,MemberCardStatusModifyActionEnum枚举
     */
    private Integer actionType;

    /**
     * 操作说明
     */
    @NotEmpty(message = "操作说明不能为空", groups = MemberCardStatusModifyActionEnum.class)
    private String actionRemark;


    /**
     * 操作人id
     */
    private Long operateUserId;

    /**
     * 操作人姓名
     */
    private String operateUserName;
}
