package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.es.pojo.qywx.MemberFlagPojo;
import com.bizvane.members.facade.vo.qywx.EsMbrFriendListRequestVO;
import com.bizvane.members.facade.vo.qywx.UpdateFriendVo;
import com.bizvane.wechatenterprise.service.entity.vo.WxQyFriendsSearchVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bizvane.members.facade.es.pojo.qywx.WxQyFriendsPojo;
import com.bizvane.members.facade.models.qywx.EsMbrFriendsModel;
import com.bizvane.members.facade.vo.qywx.FriendsInfoVo;
import com.bizvane.members.facade.vo.qywx.WxQyFriendsVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface WxFriendsApiService {

	// 查我的好友
	@RequestMapping(value = "/api/wxFriendsApi/getWxQyFriendsList", method = RequestMethod.POST)
	ResponseData<PageInfo<WxQyFriendsPojo>> getWxQyFriendsList(@RequestBody WxQyFriendsSearchVo wxQyFriendsSearchVo);

	// 查好友详情
	@RequestMapping(value = "/api/wxFriendsApi/getEsMbrFriendsDetail", method = RequestMethod.POST)
	ResponseData<EsMbrFriendsModel> getEsMbrFriendsDetail(@RequestParam("esMbrFriendsId") Long esMbrFriendsId);

	// 更新好友状态
	@RequestMapping(value = "/api/asyncUpdateMemberWithFriends", method = RequestMethod.POST)
	ResponseData<Integer> asyncUpdateMemberWithFriends(@RequestBody @Valid MemberFlagPojo memberFlagPojo);

	@RequestMapping(value = "/api/getUnionIdByExternalUserIdOrPendingId", method = RequestMethod.POST)
	ResponseData<String> getUnionIdByExternalUserIdOrPendingId(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId, @RequestParam("externalUserId") String externalUserId, @RequestParam("pendingId") String pendingId);


}
