package com.bizvane.members.facade.service.baison;

import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.po.MbrUniversalBindChannelPo;
import com.bizvane.members.facade.vo.BaisonMemberRequestVo;
import com.bizvane.members.facade.vo.BaisonMemberResponseVo;
import com.bizvane.members.facade.vo.BaisonRequestVo;
import com.bizvane.members.facade.vo.MembersSysVo;
import com.bizvane.members.facade.vo.yanzhiwu.MemberThirdBindChannelRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface ApiBaisonService {

    @PostMapping("/api/apiBaison/queryMemberSysInfo")
    ResponseData<MembersSysVo> queryMemberSysInfo(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("brandId") Long brandId);

    @PostMapping("/api/apiBaison/queryMbrUniversalBindChannel")
    ResponseData<MbrUniversalBindChannelPo> queryMbrUniversalBindChannel(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("brandId") Long brandId, @RequestParam("memberCode") String memberCode, @RequestParam("channelType") Integer channelType);

    @PostMapping("/api/apiBaison/saveMbrUniversalBindChannel")
    ResponseData saveMbrUniversalBindChannel(@RequestBody MemberThirdBindChannelRequestVo bindChannelRequestVo);

    @PostMapping("/api/apiBaison/sendOpenCard2MQMessage")
    ResponseData sendOpenCard2MQMessage(@RequestBody MemberInfoModel memberInfoModel);
}
