package com.bizvane.members.facade.enums;

/**
 * @author yuantq
 * @date 2022/10/19
 */
public enum UniversalChannelTypeMappingEnum {

    /**
     * mbrChannelId is null 代表无对应或者未找到对应
     */
    BIZVANE_CHANNEL(1, 6L,"商帆商城"),
    WEIMOB_CHANNEL(2, null,"微盟商城"),
    YOUZAN_CHANNEL(3, 11L,"有赞商城"),
    LINKFLOW(4, null,"LinkFlow"),
    JD_CHANNEL(5, null,"京东会员通"),
    NX_CHANNEL(6,null,"南讯"),
    MALL_WEIMOB_CHANNEL(8,8L,"微盟商城"),
    SF_NEW_MALL(7,14L,"商帆新微商城"),
    EHR(9,9L,"EHR"),
    OTHER_CHANNEL(10,10L,"其它渠道"),
    OFFICIAL_WEBSITE_CHANNEL(15,15L,"官网"),
    ;

    /**
     * 渠道类型
     */
    private Integer channelType;

    /**
     * 会员全渠道ID{@link OpenCardChannelEnum}
     */
    private Long mbrChannelId;

    private String remark;

    UniversalChannelTypeMappingEnum(Integer channelType, Long mbrChannelId, String remark) {
        this.channelType = channelType;
        this.mbrChannelId = mbrChannelId;
        this.remark = remark;
    }

    public Integer getChannelType() {
        return channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public Long getMbrChannelId() {
        return mbrChannelId;
    }

    public void setMbrChannelId(Long mbrChannelId) {
        this.mbrChannelId = mbrChannelId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }}
