package com.bizvane.members.facade.vo.qywx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
 * @author baofeng@bizvane.cn
 * @createTime 2022-09-08 11:51:42
 * @description: 商品秀导购分享订单分页列表查询请求对象
 */
@ApiModel(value = "商品秀导购分享分页订单列表查询结果对象")
@Getter
@Setter
public class MallShareOrderListResponseVO {

    @ApiModelProperty(name = "mbrMallShareOrderId", value = "PK", example = "")
    private Long mbrMallShareOrderId;

    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", example = "1L")
    private Long sysCompanyId;

    @ApiModelProperty(name = "sysBrandId", value = "品牌ID", example = "1L")
    private Long sysBrandId;

    @ApiModelProperty(name = "memberCode", value = "会员Code", example = "")
    private String memberCode;

    @ApiModelProperty(name = "userName", value = "会员名称", example = "")
    private String userName;

    @ApiModelProperty(name = "memberHeadImgUrl", value = "会员头像地址", example = "")
    private String memberHeadImgUrl;

    @ApiModelProperty(name = "orderNo", value = "订单号", example = "")
    private String orderNo;

    @ApiModelProperty(name = "orderStatus", value = "0-待付款,1-待发货,2-待收货,3-已收货,4-已完成,5-已关闭,7-待审核", example = "")
    private Integer orderStatus;

    @ApiModelProperty(name = "offlineCreateTime", value = "下单时间", example = "")
    private Date offlineCreateTime;

    @ApiModelProperty(name = "totalRealMoney", value = "商品实付/实退总金额", example = "")
    private Double totalRealMoney;

    @ApiModelProperty(name = "totalNum", value = "购买/实退总数量", example = "")
    private Integer totalNum;

    @ApiModelProperty(name = "orderCommodityVOList", value = "订单商品列表", example = "")
    private List<MallShareOrderCommodityVO> orderCommodityVOList;

}
