package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.models.BatchUpdateTransferRecordIdByEsMbrFriendsIdReqVO;
import com.bizvane.members.facade.models.BatchUpdateTransferRecordIdByEsMbrFriendsIdVO;
import com.bizvane.members.facade.vo.qywx.EsMbrFriendListRequestVO;
import com.bizvane.members.facade.vo.qywx.UpdateFriendVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bizvane.members.facade.es.pojo.qywx.WxQyFriendsPojo;
import com.bizvane.members.facade.es.vo.WxQyFriendsSearchVo;
import com.bizvane.members.facade.models.qywx.EsMbrFriendsModel;
import com.bizvane.members.facade.vo.qywx.FriendsInfoVo;
import com.bizvane.members.facade.vo.qywx.WxQyFriendsVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface WxFriendsApiService {

	// 添加多个好友，没有save 有则update
	@RequestMapping(value = "/api/wxFriendsApi/saveAndUpdateFriends", method = RequestMethod.POST)
	ResponseData<Integer> saveAndUpdateFriends(@RequestBody FriendsInfoVo friends);

	// 查我的好友
	@RequestMapping(value = "/api/wxFriendsApi/getWxQyFriendsList", method = RequestMethod.POST)
	ResponseData<PageInfo<WxQyFriendsPojo>> getWxQyFriendsList(@RequestBody WxQyFriendsSearchVo wxQyFriendsSearchVo);

	@RequestMapping(value = "/api/wxFriendsApi/getWxQyFriendsListByDB", method = RequestMethod.POST)
	ResponseData<PageInfo<WxQyFriendsPojo>> getWxQyFriendsListByDB(
			@RequestBody WxQyFriendsSearchVo wxQyFriendsSearchVo);

	// 查好友详情
	@RequestMapping(value = "/api/wxFriendsApi/getEsMbrFriendsDetail", method = RequestMethod.POST)
	ResponseData<EsMbrFriendsModel> getEsMbrFriendsDetail(@RequestParam("esMbrFriendsId") Long esMbrFriendsId);

	// 设置好友备注
	@RequestMapping(value = "/api/wxFriendsApi/updateFriendsComment", method = RequestMethod.POST)
//	@Deprecated
	ResponseData<Integer> updateFriendsComment(@RequestBody WxQyFriendsSearchVo wxQyFriendsSearchVo);

	//根据条件查询好友信息
	@RequestMapping(value = "/api/wxFriendsApi/getWxQyFriendsModel", method = RequestMethod.POST)
	ResponseData<EsMbrFriendsModel> getWxQyFriendsModel(@RequestBody WxQyFriendsVo wxQyFriendsVo);

	//更新好友状态
	@RequestMapping(value = "/api/updateFriendStatus", method = RequestMethod.POST)
	ResponseData<Integer> updateFriendStatus(@RequestBody @Valid UpdateFriendVo updateFriendVo);

	@RequestMapping(value = "/api/getUnionIdByExternalUserIdOrPendingId", method = RequestMethod.POST)
	ResponseData<String> getUnionIdByExternalUserIdOrPendingId(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId, @RequestParam("externalUserId") String externalUserId, @RequestParam("pendingId") String pendingId);

	// 根据条件查找好友详情
	@RequestMapping(value = "/api/wxFriendsApi/getEsMbrFriendByCondition", method = RequestMethod.POST)
	ResponseData<EsMbrFriendsModel> getEsMbrFriendByCondition(@RequestBody WxQyFriendsSearchVo wxQyFriendsSearchVo);

	@RequestMapping(value = "/api/wxFriendsApi/updateWxqyFriendTransferRecordIdByEsMbrFriendsId", method = RequestMethod.POST)
	ResponseData<String> updateWxqyFriendTransferRecordIdByEsMbrFriendsId(@RequestBody BatchUpdateTransferRecordIdByEsMbrFriendsIdReqVO reqVO);

	// 分页查询好友列表
	@RequestMapping(value = "/api/wxFriendsApi/pageListEsMbrFriendByCondition", method = RequestMethod.POST)
	ResponseData<PageInfo<EsMbrFriendsModel>> pageListEsMbrFriendByCondition(@RequestBody EsMbrFriendListRequestVO requestVO);

	// 根据条件查询好友数量
	@RequestMapping(value = "/api/wxFriendsApi/countFriendByCondition", method = RequestMethod.POST)
	ResponseData<Long> countFriendByCondition(@RequestBody EsMbrFriendListRequestVO requestVO);

}
