package com.bizvane.members.facade.vo.qywx;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
public class IntegralExchangeRequestVo implements Serializable {

    @ApiModelProperty(name = "sysCompanyId", value = "公司id")
    @NotNull
    private Long sysCompanyId;

    @ApiModelProperty(name = "brandId", value = "品牌Id")
    @NotNull
    private Long brandId;

    @ApiModelProperty(name = "memberCode", value = "会员code")
    @NotNull
    private String memberCode;

    @ApiModelProperty(name = "changeBills", value = "变更单据")
    @NotNull
    private String changeBills;

    @ApiModelProperty(name = "decreaseCrmIntegral", value = "crm扣减积分数量")
    @NotNull
    private Integer decreaseCrmIntegral;

    @ApiModelProperty(name = "increaseOtherIntegral", value = "有赞增加积分数量")
    @NotNull
    private Integer increaseOtherIntegral;

    @ApiModelProperty(value = "变更时间", name = "changeDate", example = "变更时间")
    @NotNull
    private Date changeDate;

}
