package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.es.pojo.BasicMembersInfoSearchPojo;
import com.bizvane.members.facade.es.vo.GroupAbilityMembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.GroupMixMembersInfoSearchVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.springframework.data.domain.Page;

import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.es.pojo.qywx.MembersFriendPojo;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018\8\13 0013.
 */
public interface MembersAdvancedSearchService {

    ResponseData<PageInfo<MemberInfoVo>> search(MembersInfoSearchVo membersInfoSearchVo, PageVo pageVo);

    ResponseData<PageInfo<MembersInfoSearchPojo>> advancedSearch(MembersInfoSearchVo membersInfoSearchVo, PageVo pageVo);

    ResponseData<PageInfo<MemberInfoSimpleVO>> advancedSimpleSearch(MembersInfoSearchVo membersInfoSearchVo, PageVo pageVo);
    
    ResponseData<String> export(MembersInfoSearchVo membersInfoSearchVo, FileTaskPo fileTaskPo);

    ResponseData<Page<MembersFriendPojo>> searchMembersFriend(MembersInfoSearchVo membersInfoSearchVo, PageVo pageVo);

    ResponseData<PageInfo<MembersFriendPojo>> getMembersListOrder(MembersInfoSearchVo membersInfoSearchVo, PageVo pageVo);

    ResponseData<PageInfo<MemberInfoVo>> searchApi(MembersInfoSearchVo membersInfoSearchVo, PageVo pageVo);

    ResponseData<PageInfo<BasicMembersInfoSearchPojo>> searchBasicMembers(MembersInfoSearchVo membersInfoSearchVo, PageVo pageVo);

    ResponseData<Map<String, Long>> searchBasicMembersGroupOpenCardTime(MembersInfoSearchVo membersInfoSearchVo, String particleSize);

    ResponseData<PageInfo<MembersInfoSearchPojo>> groupAbilitlyAdvancedSearch(GroupAbilityMembersInfoSearchVo groupAbilityMembersInfoSearchVo, PageVo pageVo);

    ResponseData<PageInfo<MemberInfoModel>> groupMixAdvancedSearch(GroupMixMembersInfoSearchVo groupMixMembersInfoSearchVo, PageVo pageVo);

    public BoolQueryBuilder getEsWhere(MembersInfoSearchVo infoSearchVo, BoolQueryBuilder builder);
}
