package com.bizvane.members.facade.ur.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
@ApiModel(value = "会员注册")
public class UrMemberCardRequestVo {

    @ApiModelProperty(name = "offlineCompanyCode", value = "线下企业code", example = "C3000", dataType = "String")
    @NotNull
    private String offlineCompanyCode;
    @ApiModelProperty(name = "sysCompanyId", value = "线下品牌code", example = "001", dataType = "String")
    @NotNull
    private String offlineBrandCode;

    @ApiModelProperty(name = "sysCompanyId", value = "企业id", example = "1", dataType = "String")
    @NotNull
    private Long sysCompanyId;
    @ApiModelProperty(name = "brandId", value = "品牌id", example = "2", dataType = "String")
    @NotNull
    private Long brandId;
    @ApiModelProperty(name = "mobileTel", value = "手机号", example = "117602100074", dataType = "String")
    @NotNull
    private String mobileTel;
    @ApiModelProperty(name = "customerName", value = "会员名称", example = "小明", dataType = "String")
    private String customerName;
    @ApiModelProperty(name = "sex", value = "性别 1女0男", example = "1", dataType = "String")
    private Integer sex;
    @ApiModelProperty(name = "birthday", value = "yyyy-MM-dd", example = "1", dataType = "String")
    private String birthday;
    @ApiModelProperty(name = "wxOpenId", value = "yyyy-MM-dd", example = "1", dataType = "String")
    private String wxOpenId;
    @ApiModelProperty(name = "wxUnionId", value = "yyyy-MM-dd", example = "1", dataType = "String")
    private String wxUnionId;
    @ApiModelProperty(name = "shopId", value = "店铺code 注册门店", example = "U123456", dataType = "String")
    private String shopId;
    @ApiModelProperty(name = "registerType", value = "注册类型 0LPOS 1官网", example = "1", dataType = "String")
    private Integer registerType;
    @ApiModelProperty(name = "storeId", value = "店铺code 所属门店", example = "UR999999", dataType = "String")
    private String storeId;
    @ApiModelProperty(name = "vipTypeId", value = "卡类型id（code）等级", example = "UR000024", dataType = "String")
    private String vipTypeId;
    @ApiModelProperty(name = "cardTypeId", value = "卡类型名称 也是等级id", example = "UR000024", dataType = "String")
    private String cardTypeId;
    @ApiModelProperty(name = "vipTypeCode", value = "卡类型编号", example = "UR000024", dataType = "String")
    private String vipTypeCode;
    @ApiModelProperty(name = "openStatus", value = "会员卡状态(1正常卡 0禁用)", example = "1", dataType = "String")
    private String openStatus;
    @ApiModelProperty(name = "effectiveTime", value = "失效年月日", example = "2100-01-01", dataType = "String")
    private String effectiveTime;
    @ApiModelProperty(name = "points", value = "默认积分", example = "0", dataType = "String")
    private Integer points;

    private String password;

}
