package com.bizvane.members.facade.vo;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class MemberCouponExpireRequestVo implements Serializable {



    @NotNull(message = "企业不能为空")
    private Long sysCompanyId;
    @NotNull(message = "品牌不能为空")
    private Long brandId;
    //过期天数
    @Min(value = 0,message = "过期天数不能小于0")
    @Max(value = 100,message = "过期天数不能大于100")
    private Integer expireDay;
    //门店
    private Long serviceStoreId;
    //导购
    private Long serviceGuideId;
    //起始页
    private Integer pageNum ;
    //页数
    private Integer pageSize;

    //会员code集合
    private List<String> memberCodeList;



}
