package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.vo.IntegralRecordBusinessTypeVo;

import java.util.Map;

/**
 * @author dingShiChen
 * @since 2019/10/23
 */
public interface IntegralRecordBusinessTypeService {

	/**
	 * 根据商帆规则code获取描述(过期)
	 * @param bizvaneBusinessCode 商帆规则的code
	 * @return
	 */
	String findByBizvaneCode(String bizvaneBusinessCode);

	/**
	 * 根据code获取描述(过期)
	 * @param businessCode
	 * @param sysCompanyId
	 * @return
	 */
	String findByCode(String businessCode, Long sysCompanyId);

	/**
	 * 根据code获取描述对象
	 * @param businessCode
	 * @param sysCompanyId
	 * @return
	 */
	IntegralRecordBusinessTypeVo findIntegralRecordBusinessTypeVoByCode(String businessCode, Long sysCompanyId);

	/**
	 * 根据code获取描述对象(新)
	 * @param businessCode
	 * @param sysCompanyId
	 * @return
	 */
	IntegralRecordBusinessTypeVo findIntegralRecordBusinessTypeVoByBusinessCodeNew(String businessCode, Long sysCompanyId);

	/**
	 * 根据线下code获取描述对象
	 * @param offlineBusiness
	 * @param sysCompanyId
	 * @return
	 */
	IntegralRecordBusinessTypeVo findIntegralRecordBusinessTypeVoByOfflineBusinessCode(String offlineBusiness, Long sysCompanyId);

	/**
	 * 企业定制型线上积分类型转线下类型
	 *
	 * @param sysCompanyId
	 * @return
	 */
	Map<String, String> convertOnLineTypeToOffline(Long sysCompanyId);

	/**
	 * 标准线上积分类型转线下类型
	 *
	 * @param
	 * @return
	 */
	Map<String, String> standardConvertOnLineTypeToOffline();


	/**
	 * 兼容普通code和bizvane-开头的code(过期)
	 * @param businessCode
	 * @param sysCompanyId
	 * @return
	 */
	String findByCodeCompatibility(String businessCode,Long sysCompanyId);

    /**
     * 根据积分类型判断是否为默认店铺
     */
	Boolean judgeBusinessTypeDefault(String businessType);

    /**
     * 根据类型返回判断是否为服务门店
     */
    Boolean judgeBusinessTypeService(String businessType);
}
