package com.bizvane.members.facade.models.po;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MbrCheckGradePO implements Serializable {
    /**
     * 保级时间设置 id
     */
    private Integer mbrCheckGradeId;

    /**
     * 公司id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long brandId;

    /**
     * 年
     */
    private String year;

    /**
     * 月
     */
    private String month;

    /**
     * 日
     */
    private String day;

    /**
     * 升降级类型 0 降级 1升级
     */
    private Integer type;

    /**
     * 保级状态 0=未开始  1=已开始
     */
    private Integer keepStatus;

    /**
     * 降级任务开关 0关闭 1开启
     */
    private Integer switchToDown;

    /**
     * 降级保护开关针对升级 0关 1开
     */
    private Integer switchToProtect;

    /**
     * 保护期时长针对升级
     */
    private Integer protectTime;

    /**
     * 是否有效
     */
    private Boolean valid;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建人姓名
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 修改人id
     */
    private Long modifiedUserId;

    /**
     * 修改人姓名
     */
    private String modifiedUserName;

    /**
     * 修改时间
     */
    private Date modifiedDate;

    /**
     * 版本号
     */
    private Integer version;

    /**
     * 时间模式。0=日历模式，1=每日定时模式
     */
    private Boolean timeModel;

    /**
     * 每日定时模式下开始执行日期
     */
    private Date startTime;

    /**
     * 降级保护开关针对降级 0关 1开
     */
    private Integer switchToProtectLess;

    /**
     * 保护期时长针对降级
     */
    private Integer protectTimeLess;

    private static final long serialVersionUID = 1L;

}