package com.bizvane.members.facade.service.datafetch.model;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: houkai
 * @Date: 2018/8/10 11:15
 * @Description: 订单明细取数器对象
 */
@Data
public class MemberOrderDetailFetchModel extends BaseFetchModel implements Serializable {

    private static final long serialVersionUID = -1474504828619969465L;

    private String orderNo; //所属订单

    private String orderDetailNo; //订单详情编号

    private String productItemId; //条码

    private Integer quantity; //数量

    private String specification; //规格（商品样式）

    private String color; //颜色

    private String size; //大小

    private String offlineProductGuideCode;//商品导购线下code

    private String productGuideName;//商品导购name

    private String productNo; //商品编号

    private String productName; //商品名称

    private BigDecimal tagPrice; //吊牌价

    private BigDecimal tradeAmountDetail; //成交价

    private Integer activity; //是否参与活动1:是,2:否

    private String remark; //备注

    private String orderType;//订单类型 1其他订单 2微商城订单

    private String sku; //商品sku

    private String serviceGuideIds; //服务导购ids

    private String serviceGuideProportion;  //提成比例

}
