package com.bizvane.members.facade.service.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.vo.MbrGroupVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

/**
 * @Author: houkai
 * @Date: 2018/7/27 15:14
 * @Description:会员分组对外接口
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface MemberGroupApiService {

    /**
     * 新建会员默认分组
     *
     * @param mbrGroupModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/addGroup", method = RequestMethod.POST)
    ResponseData addGroup(@RequestBody MbrGroupModel mbrGroupModel) throws MemberException;


    /**
     * 查询会员默认分组详情
     */
    @RequestMapping(value = "/api/queryGroupInfo", method = RequestMethod.POST)
    ResponseData <MbrGroupModel> queryGroupInfo(@RequestParam("mbrGroupDefId") Long mbrGroupDefId) throws MemberException;


    /**
     * 更新会员默认分组
     *
     * @param mbrGroupModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/updateMemberGroup", method = RequestMethod.POST)
    ResponseData updateMemberGroup(@RequestBody MbrGroupModel mbrGroupModel) throws MemberException;

    /**
     * 查询默认分组类型内会员默认分组列表
     *
     * @param mbrGroupVo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryGroupList", method = RequestMethod.POST)
    ResponseData <PageInfo <MbrGroupModel>> queryGroupList(@RequestBody MbrGroupVo mbrGroupVo) throws MemberException;

    /**
     * 复制会员分组
     *
     * @param mbrGroupModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/addGroupByCopy", method = RequestMethod.POST)
    ResponseData addGroupByCopy(@RequestBody MbrGroupModel mbrGroupModel) throws MemberException;

    /**
     * 删除会员分组
     *
     * @param mbrGroupModel
     * @return
     * @throws MemberException
     */
    @PostMapping(value = "/api/deleteGroup")
    ResponseData deleteGroup(@RequestBody MbrGroupModel mbrGroupModel) throws MemberException;

    /**
     * 启用禁用会员分组
     *
     * @param mbrGroupModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/updateGroupStatus", method = RequestMethod.POST)
    ResponseData updateGroupStatus(@RequestBody MbrGroupModel mbrGroupModel) throws MemberException;

    /**
     * 获取会员分组信息
     * @param brandId
     * @param groupName
     * @return
     */
    @RequestMapping(value = "/api/queryGroupByGroupName", method = RequestMethod.POST)
    ResponseData<MbrGroupModel> queryGroupByGroupName(@RequestParam("brandId")Long brandId,@RequestParam("groupName")String groupName);
}
