package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @author huangxinliu
 * @date: 2021/1/25 14:50
 */
public interface MemberDesensitizeService {

    /**
     * 根据账号配置决定脱敏会员信息
     */
    void encryptByAccountConfig(SysAccountPO sysAccountPO, MemberInfoVo memberInfoVo);
    void encryptByAccountConfig(SysAccountPO sysAccountPO, ResponseData<PageInfo<MemberInfoVo>> res);

    /**
     * 根据账号配置决定脱敏会员分组
     */
    void encryptMbrGroupModelByAccountConfig(SysAccountPO sysAccountPO, MbrGroupModel mbrGroupModel);
    void encryptMbrGroupModelResByAccountConfig(SysAccountPO sysAccountPO, ResponseData<PageInfo<MbrGroupModel>> res);

    /**
     * 根据账号配置决定脱敏积分流水
     */
    void encryptIntegralRecordModelPageInfoByAccountConfig(SysAccountPO sysAccountPO, PageInfo<IntegralRecordModel> pageInfo);


    Boolean getMemberDataDesensitizeByAccountConfig(Long sysAccountId);
    Boolean getMemberDataDesensitizeByAccountConfig(SysAccountPO sysAccountPO);
    
}
