package com.bizvane.members.facade.service.api.vg;/*
 * @author gp.n
 * @date 2021-1-27
 *
 * */

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.vg.vo.AllCardResponseVO;
import com.bizvane.members.facade.vo.MemberInfoApiModel;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface VGMemberInfoRpcService {
    /**
     * 通过GroupMemberCode获得会员所有俱乐部卡信息
     *
     * @param groupMemberCode
     * @return
     */
    @RequestMapping(value = "/VGMembersInfo/getAllCardByGroupMemberCode", method = RequestMethod.GET)
    ResponseData<List<AllCardResponseVO>> getMemberInfo(@RequestParam String groupMemberCode)
            throws MemberException;

}
