package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.OrderEvaluateModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.models.query.OrderEvaluateQueryPo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * @Author: houkai
 * @Date: 2018/7/24 09:11
 * @Description:
 */
public interface OrderEvaluateService {
    /**
     * 查询品牌下订单评价列表
     *
     * @param paraMap
     * @param pageVo
     * @return
     */
    ResponseData<PageInfo<OrderEvaluateModel>> queryOrderEvaluateList(OrderEvaluateQueryPo orderEvaluateQueryPo, PageVo pageVo);

    /**
     * 查询订单详情
     *
     * @param orderNo
     * @return
     */
    public ResponseData<OrderModel> queryOrderInfo(String orderNo,Long sysBrandId);

    /**
     * 查询订单评价详情
     *
     * @param orderNo
     * @return
     */
    ResponseData<OrderEvaluateModel> queryOrderEvaluateInfo(String orderNo,Long sysBrandId);

    /**
     * 查询评价个数
     *
     * @param paraMap
     * @return
     */
    Long queryEvaluateCount(OrderEvaluateQueryPo orderEvaluateQueryPo);

    /**
     * 查询订单评价列表 excel
     *
     * @param paraMap
     * @param start
     * @param size
     * @return
     */
    List<OrderEvaluateModel> queryOrderEvaluateList(OrderEvaluateQueryPo orderEvaluateQueryPo, Long start, Long size);
}
