/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.utils;

import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyPo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.messagebase.model.vo.StandardTemplateResponseVO;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GuavaUtils {
    public static String CACHE_COMPANY_KEY = "members:cache_company_key:";
    public static Cache<String, SysCompanyPo> cacheSysCompanyPo = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    public static String CACHE_BRAND_KEY = "members:cache_brand_key:";
    public static Cache<String, SysBrandPo> cacheSysBrandPo = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    public static String CACHE_BRAND_LIST_KEY = "members:cache_brand_list_key:";
    public static Cache<String, List<SysBrandPo>> cacheSysBrandPoList = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    public static String CACHE_MEMBER_SYS_MODEL_KEY = "members:cache_member_sys_model_key:";
    public static Cache<String, MembersSysModel> cacheMembersSysModel = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static String CACHE_MBR_LEVEL_KEY = "members:cache_mbr_level_key:";
    public static Cache<String, MbrLevelModel> cacheMbrLevelModel = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static String CACHE_WX_PUBLIC_KEY = "members:cache_wx_public_key:";
    public static Cache<String, WxPublicPO> cacheWxPublicModel = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static String CACHE_SYS_STAFF_KEY = "members:cache_sys_staff_key:";
    public static Cache<String, SysStaffPo> cacheSysStaffModel = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static String CACHE_SYS_STORE_KEY = "members:cache_sys_store_key:";
    public static Cache<String, SysStorePo> cacheSysStoreKey = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static String CACHE_MEMBER_INFO_MODEL_AND_LEVEL_KEY = "members:cache_member_info_model_and_level_key:";
    public static Cache<String, MemberInfoModel> cacheMemberInfoModelAndLevelKey = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static String CACHE_MEMBER_INFO_MODEL_KEY = "members:cache_member_info_model_key:";
    public static Cache<String, MemberInfoModel> cacheMemberInfoModelKey = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static String CACHE_STANDARD_TEMPLATE_RESPONSE_VO_KEY = "members:cache_standard_template_response_vo_key:";
    public static Cache<String, StandardTemplateResponseVO> cacheStandardTemplateResponseVoKey = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    public static String CACHE_ORDER_COMPANY_KEY = "members:order:cache_company_key:";
    public static Cache<String, SysCompanyPo> cacheOrderSysCompanyPo = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.SECONDS).build();
    public static String CACHE_ORDER_BRAND_KEY = "members:order:cache_brand_key:";
    public static Cache<String, SysBrandPo> cacheOrderSysBrandPo = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.SECONDS).build();

    public static void setSysCompanyPo(Long sysCompanyId, SysCompanyPo model) {
        if (sysCompanyId != null && model != null) {
            cacheSysCompanyPo.put((Object)(CACHE_COMPANY_KEY + sysCompanyId), (Object)model);
        }
    }

    public static SysCompanyPo getSysCompanyPo(Long sysCompanyId) {
        return (SysCompanyPo)cacheSysCompanyPo.getIfPresent((Object)(CACHE_COMPANY_KEY + sysCompanyId));
    }

    public static void setSysBrandPo(Long sysBrandId, SysBrandPo model) {
        if (sysBrandId != null && model != null) {
            cacheSysBrandPo.put((Object)(CACHE_BRAND_KEY + sysBrandId), (Object)model);
        }
    }

    public static SysBrandPo getSysBrandPo(Long sysBrandId) {
        return (SysBrandPo)cacheSysBrandPo.getIfPresent((Object)(CACHE_BRAND_KEY + sysBrandId));
    }

    public static void setSysBrandPoList(Long sysCompanyId, List<SysBrandPo> sysBrandPoList) {
        if (sysCompanyId != null && CollectionUtils.isNotEmpty(sysBrandPoList)) {
            cacheSysBrandPoList.put((Object)(CACHE_BRAND_LIST_KEY + sysCompanyId), sysBrandPoList);
        }
    }

    public static List<SysBrandPo> getSysBrandPoList(Long sysCompanyId) {
        return (List)cacheSysBrandPoList.getIfPresent((Object)(CACHE_BRAND_LIST_KEY + sysCompanyId));
    }

    public static void setMemberSysModel(Long sysBrandId, MembersSysModel model) {
        if (sysBrandId != null && model != null) {
            cacheMembersSysModel.put((Object)(CACHE_MEMBER_SYS_MODEL_KEY + sysBrandId), (Object)model);
        }
    }

    public static MembersSysModel getMemberSysModel(Long sysBrandId) {
        return (MembersSysModel)cacheMembersSysModel.getIfPresent((Object)(CACHE_MEMBER_SYS_MODEL_KEY + sysBrandId));
    }

    public static void setMbrLevelModel(Long mbrLevelId, MbrLevelModel model) {
        if (mbrLevelId != null && model != null) {
            cacheMbrLevelModel.put((Object)(CACHE_MBR_LEVEL_KEY + mbrLevelId), (Object)model);
        }
    }

    public static MbrLevelModel getMbrLevelModel(Long mbrLevelId) {
        return (MbrLevelModel)cacheMbrLevelModel.getIfPresent((Object)(CACHE_MBR_LEVEL_KEY + mbrLevelId));
    }

    public static void setWxPublicModel(String appId, WxPublicPO model) {
        if (StringUtil.isNotEmpty((CharSequence)appId) && model != null) {
            cacheWxPublicModel.put((Object)(CACHE_WX_PUBLIC_KEY + appId), (Object)model);
        }
    }

    public static WxPublicPO getWxPublicModel(String appId) {
        return (WxPublicPO)cacheWxPublicModel.getIfPresent((Object)(CACHE_WX_PUBLIC_KEY + appId));
    }

    public static void setWxPublicModel(Long sysBrandId, WxPublicPO model) {
        if (sysBrandId != null && model != null) {
            cacheWxPublicModel.put((Object)(CACHE_WX_PUBLIC_KEY + sysBrandId), (Object)model);
        }
    }

    public static WxPublicPO getWxPublicModel(Long sysBrandId) {
        return (WxPublicPO)cacheWxPublicModel.getIfPresent((Object)(CACHE_WX_PUBLIC_KEY + sysBrandId));
    }

    public static void setSysStaffPo(Long sysStaffId, SysStaffPo model) {
        if (sysStaffId != null && model != null) {
            cacheSysStaffModel.put((Object)(CACHE_SYS_STAFF_KEY + sysStaffId), (Object)model);
        }
    }

    public static SysStaffPo getSysStaffPo(Long sysStaffId) {
        return (SysStaffPo)cacheSysStaffModel.getIfPresent((Object)(CACHE_SYS_STAFF_KEY + sysStaffId));
    }

    public static void setSysStorePo(Long sysStoreId, SysStorePo model) {
        if (sysStoreId != null && model != null) {
            cacheSysStoreKey.put((Object)(CACHE_SYS_STORE_KEY + sysStoreId), (Object)model);
        }
    }

    public static SysStorePo getSysStorePo(Long sysStoreId) {
        return (SysStorePo)cacheSysStoreKey.getIfPresent((Object)(CACHE_SYS_STORE_KEY + sysStoreId));
    }

    public static void setMemberInfoModelAndLevelByMemberCode(String memberCode, MemberInfoModel memberInfoModel) {
        if (StringUtils.isNotBlank((CharSequence)memberCode) && memberInfoModel != null) {
            cacheMemberInfoModelAndLevelKey.put((Object)(CACHE_MEMBER_INFO_MODEL_AND_LEVEL_KEY + memberCode), (Object)memberInfoModel);
        }
    }

    public static MemberInfoModel getMemberInfoModelAndLevelByMemberCode(String memberCode) {
        return (MemberInfoModel)cacheMemberInfoModelAndLevelKey.getIfPresent((Object)(CACHE_MEMBER_INFO_MODEL_AND_LEVEL_KEY + memberCode));
    }

    public static void setMemberInfoModelByMemberCode(String memberCode, MemberInfoModel memberInfoModel) {
        if (StringUtils.isNotBlank((CharSequence)memberCode) && memberInfoModel != null) {
            cacheMemberInfoModelKey.put((Object)(CACHE_MEMBER_INFO_MODEL_KEY + memberCode), (Object)memberInfoModel);
        }
    }

    public static MemberInfoModel getMemberInfoModelByMemberCode(String memberCode) {
        return (MemberInfoModel)cacheMemberInfoModelKey.getIfPresent((Object)(CACHE_MEMBER_INFO_MODEL_KEY + memberCode));
    }

    public static void setStandardTemplateResponseVo(Long sysCompanyId, Long sysBrandId, String templateType, StandardTemplateResponseVO standardTemplateResponseVO) {
        if (sysCompanyId != null && sysBrandId != null && StringUtils.isNotBlank((CharSequence)templateType) && standardTemplateResponseVO != null) {
            cacheStandardTemplateResponseVoKey.put((Object)(CACHE_STANDARD_TEMPLATE_RESPONSE_VO_KEY + "_" + sysCompanyId + "_" + sysBrandId + "_" + templateType), (Object)standardTemplateResponseVO);
        }
    }

    public static StandardTemplateResponseVO getStandardTemplateResponseVOByMemberCode(Long sysCompanyId, Long sysBrandId, String templateType) {
        return (StandardTemplateResponseVO)cacheStandardTemplateResponseVoKey.getIfPresent((Object)(CACHE_STANDARD_TEMPLATE_RESPONSE_VO_KEY + "_" + sysCompanyId + "_" + sysBrandId + "_" + templateType));
    }

    public static void setOrderSysCompanyPo(Long sysCompanyId, SysCompanyPo model) {
        if (sysCompanyId != null && model != null) {
            cacheOrderSysCompanyPo.put((Object)(CACHE_ORDER_COMPANY_KEY + sysCompanyId), (Object)model);
        }
    }

    public static SysCompanyPo getOrderSysCompanyPo(Long sysCompanyId) {
        return (SysCompanyPo)cacheOrderSysCompanyPo.getIfPresent((Object)(CACHE_ORDER_COMPANY_KEY + sysCompanyId));
    }

    public static void setOrderSysBrandPo(Long sysCompanyId, String brandCode, SysBrandPo model) {
        if (sysCompanyId != null && StringUtil.isNotEmpty((CharSequence)brandCode) && model != null) {
            cacheOrderSysBrandPo.put((Object)(CACHE_ORDER_BRAND_KEY + sysCompanyId + "_" + brandCode), (Object)model);
        }
    }

    public static SysBrandPo getOrderSysBrandPo(Long sysCompanyId, String brandCode) {
        return (SysBrandPo)cacheOrderSysBrandPo.getIfPresent((Object)(CACHE_ORDER_BRAND_KEY + sysCompanyId + "_" + brandCode));
    }
}

