package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author SF
 */
@Data
public class MemberAuthorizeAddTaskRequestVo {


    @ApiModelProperty(name = "brandId", value = "创建者俱乐部id")
    private Long brandId;

    @NotNull
    @ApiModelProperty(name = "mbrAuthorizeTaskName", value = "授权标题")
    private String mbrAuthorizeTaskName;

    @NotNull
    @ApiModelProperty(name = "isLongTimeTask", value = "是否为长期任务(0:false;1:true)")
    private Boolean isLongTimeTask;

    @ApiModelProperty(name = "mbrAuthorizeTaskStartTime", value = "会员授权任务开始时间")
    private Date mbrAuthorizeTaskStartTime;

    @ApiModelProperty(name = "mbrAuthorizeTaskEndTime", value = "会员授权任务结束时间")
    private Date mbrAuthorizeTaskEndTime;

    @ApiModelProperty(name = "mbrFilterConditionType", value = "会员圈选过滤类型（0:全部会员；1:会员分组；2:圈定会员）")
    private Integer mbrFilterConditionType;

    @ApiModelProperty(name = "mbrFilterConditionText", value = "会员圈选过滤条件内容")
    private String mbrFilterConditionText;

    @ApiModelProperty(name = "mbrAuthorizeText", value = "授权说明")
    private String mbrAuthorizeText;

    @ApiModelProperty(name = "mbrPushNumbers", value = "推送次数")
    private Integer mbrPushNumbers;

    @ApiModelProperty(name = "agreeButton", value = "是否勾选同意（0：false；1：true）")
    private Boolean agreeButton;

    @ApiModelProperty(name = "agreeButton", value = "是否勾选取消（0：false；1：true）")
    private Boolean rejectButton;

    @ApiModelProperty(name = "authorizeTaskRank", value = "排序值（数值越大，越靠前展示）")
    private Integer authorizeTaskRank;

    @ApiModelProperty(name = "memberCount", value = "筛选总数")
    private Integer memberCount;
}
