package com.bizvane.members.facade.vo.vg;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class VGMemberIntegralChangeVo {

    @NotNull(message = "sysCompanyId不能为空")
    private Long sysCompanyId;

    @NotEmpty(message = "brandCode必须填")
    private String brandCode;

    @NotEmpty(message = "积分变更唯一流水号必须填")
    private String serialNumber;

    @NotEmpty(message = "会员卡号必须填")
    private String cardNo;

    @NotNull(message = "调整积分数不能为空")
    @Max(value = Integer.MAX_VALUE,message = "调整积分不能大于" + Integer.MAX_VALUE)
    @Min(value = Integer.MIN_VALUE,message = "调整积分不能小于" + Integer.MIN_VALUE)
    private Integer changeIntegral;

    @NotEmpty(message = "店铺code必须填")
    private String storeCode;

    private String changeDate;

    private String source;

    private String changeBills;

    private String businessWay;

    private String changeRemark;

    /**
     * 数据来源是否来之与微盟，true: 是微盟， false: 不是
     */
    private Boolean hasWm;

}
