package com.bizvane.members.facade.service.vg;

import com.bizvane.members.facade.es.pojo.IntegralInfoSearchPojo;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.vo.vg.VGMemberIntegralChangeVo;
import com.bizvane.members.facade.vo.vg.VGMemberIntegralRecordResponseVO;
import com.bizvane.members.facade.vo.vg.VGMemberIntegralRecordVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.PostConstruct;
import javax.validation.Valid;

/**
 * 锦鸿积分流水查询接口
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface VGIntegralRecordApiService {

    /**
     * 获取积分流水
     * @param vo
     * @return
     */
    @PostMapping("/api/jinhong/getIntegralRecord")
    ResponseData<PageInfo<VGMemberIntegralRecordResponseVO>> getIntegralRecord(@RequestBody @Valid VGMemberIntegralRecordVO vo);

    /**
     * 调整积分
     * @param vgMemberIntegralChangeVo
     * @return
     */
    @PostMapping("/api/jinhong/integralChangeOperate")
    ResponseData integralChangeOperate(@RequestBody @Valid VGMemberIntegralChangeVo vo);
}
