package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrDefinedGroupModel;
import com.bizvane.members.facade.vo.qywx.MainIndexResponseVo;
import com.bizvane.members.facade.vo.qywx.MbrDefinedGroupVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/11/26 15:56
 * @Description:
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface MbrDefinedGroupApiService {
    /**
     * 新增自定义分组
     *
     * @param mbrDefinedGroupModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/definedGroup/saveDefinedGroup", method = RequestMethod.POST)
    ResponseData saveDefinedGroup(@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel) throws MemberException;

    /**
     * 查询导购所属自定义分组
     *
     * @param mbrDefinedGroupModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/definedGroup/queryDefinedGroupList", method = RequestMethod.POST)
    ResponseData<List<MbrDefinedGroupModel>> queryDefinedGroupList(@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel) throws MemberException;

    /**
     * 查询自定义分组详情
     *
     * @param mbrDefinedGroupModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/definedGroup/queryDefinedGroupInfo", method = RequestMethod.POST)
    ResponseData<MbrDefinedGroupVo> queryDefinedGroupInfo(@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel) throws MemberException;

    /**
     * 删除自定义分组
     *
     * @param mbrDefinedGroupModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/definedGroup/deleteDefinedGroup", method = RequestMethod.POST)
    ResponseData deleteDefinedGroup(@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel) throws MemberException;
    
    /**
     * 获取首页6个自定义分组人群
     * @return
     * @throws MemberException
     */
    @RequestMapping(value="/api/definedGroup/get6MainIndexDefinedGroup",method=RequestMethod.POST)
    ResponseData<List<MainIndexResponseVo>> get6MainIndexDefinedGroup(@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel)throws MemberException;
}
