package com.bizvane.members.facade.service.vg;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.vo.LevelRecordVo;
import com.bizvane.members.facade.vo.vg.*;
import com.bizvane.stagekafkaservice.models.po.SysStaffPo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface VGMemberApiService {


    @PostMapping(value = "/api/jinhong/openCard")
    ResponseData<VGMemberOpenCardResponseVo> openCard(@RequestBody @Valid VGMemberOpenCardRequestVo requestVo);

    @PostMapping(value = "/api/jinhong/memberQuery")
    ResponseData<VGMemberQueryResponseVo> memberQuery(@RequestBody @Valid VGMemberQueryRequestVo requestVo);

    @PostMapping(value = "/api/jinhong/changeMemberLevel")
    ResponseData changeMemberLevel(@RequestBody @Valid VGMemberLevelChangeVo vo);

    @PostMapping(value = "/api/jinhong/changeMemberPhone")
    ResponseData changeMemberPhone(@RequestBody @Valid VGMemberPhoneChangeVo vo);

    @PostMapping(value = "/api/jinhong/memberInitGuideQuery")
    ResponseData<MemberInitGuideQueryResponseVo> memberInitGuideQuery(@RequestBody @Valid MemberInitGuideQueryRequestVo requestVo);
}
