package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: houkai
 * @Date: 2018/7/30 20:04
 * @Description:会员通会员基本信息
 */
@Data
public class MemberCardLevelModel implements Serializable {

    private static final long serialVersionUID = -7781874198944293766L;

    @ApiModelProperty(value = "微信头像", name = "wxHeadPortraits", example = "微信头像")
    private String wxHeadPortraits;

    @ApiModelProperty(value = "微信昵称", name = "wxNick", example = "微信昵称")
    private String wxNick;

    @ApiModelProperty(value = "会员可用积分", name = "countIntegral", example = "会员可用积分")
    private Integer countIntegral;

    @ApiModelProperty(value = "会员卡等级名", name = "levelName", example = "会员卡等级名")
    private String levelName;

    @ApiModelProperty(value = "会员卡等级别名", name = "levelAliasName", example = "会员卡等级名")
    private String levelAliasName;

    @ApiModelProperty(value = "会员等级id", name = "levelId", example = "会员等级id")
    private Long levelId;

    @ApiModelProperty(value = "会员卡条形码", name = "barCode", example = "会员卡条形码")
    private String barCode;

    @ApiModelProperty(value = "线上卡号", name = "cardNo", example = "线上卡号")
    private String cardNo;

    @ApiModelProperty(value = "线下卡号", name = "offlineCardNo", example = "线下卡号")
    private String offlineCardNo;

    @ApiModelProperty(value = "会员卡折扣", name = "memberDiscount", example = "会员卡折扣")
    private String memberDiscount;

    @ApiModelProperty(value = "会员卡折上折", name = "additionalDiscount", example = "会员卡折上折")
    private String additionalDiscount;

    @ApiModelProperty(value = "微信openid", name = "wxOpenId", example = "微信openid")
    private String wxOpenId;
    @ApiModelProperty(value = "储值卡号", name = "wxOpenId", example = "x111111")
    private String petCard;

    @ApiModelProperty(value ="微信unionId",name = "wxUnionId")
    private String wxUnionId;

    @ApiModelProperty(value ="会员唯一标志",name = "memberCode")
    private String memberCode;
}
