package com.bizvane.members.facade.vo.vg;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class VGMemberOpenCardRequestVo {

    @NotNull(message = "sysCompanyId不能为空")
    private Long sysCompanyId;//公司id

    private String offlineCompanyCode = "JH";

    @NotEmpty(message = "brandCode必须填")
    private String brandCode;//	是	string	品牌
    @NotEmpty(message = "phone必须填")
    private String phone;//	是	string	手机号
    @NotNull(message = "source不能为空")
    private Integer source;//	是	int	会员注册渠道 : 1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他

    private String name;    //否	string	会员名称
    private Integer sex;    //否	int	性别 : 1.女 2.男 3.未知
    private String province;//	否	string	省
    private String city;//	否	string	市
    private String county;//	否	string	区
    private String address;//	否	string	会员详细地址
    private String email;//	否	string	会员邮箱
    private String idCard;//	否	string	会员身份证号
    private String birthday;//	否	string	会员生日 格式 : yyyy-mm-dd
    private String storeCode;//	否	string	注册门店code,如果为空则默认按照中台配置的会员卡体系为准
    //guideCode
    private String guideCode;//否 string 导购code,如果为空则默认按照中台配置的会员卡体系为准
    private String levelCode;//	否	string	会员等级code,如果为空则默认按照中台配置的会员卡体系为准
    private String wxUnionId;//	否	string	微信unionId
    /**
     * 服务导购
     * */
    private String serviceGuideCode;

    /**
     * 服务门店
     * */
    private String serviceStoreCode;
    private Date openCardTime;
    private String remark;

}
