package com.bizvane.members.facade.enums.vg;

import java.util.ArrayList;
import java.util.List;

public enum VGCardPrefixEnum {

    /**
     * 锦泓 集团卡
     */
    JH("JH","无渠道参数","通过不含俱乐部属性的渠道注册开卡，例如：自然流量搜索","JH","开卡","默认店铺","默认导购",null),
    /**
     * 集团商城开卡
     */
    MALL_CLUB("MALL-CLUB","公众号通过带参链接进入小程序记录集团商城","通过集团商城线上渠道注册开卡","SC","开卡+入会","默认店铺","默认导购",null),
    /**
     * 南京云锦扫码开卡
     */
    YJ_CLUB_1("YJ-CLUB","门店扫码通过导购所属店铺归属南京云锦判断来源","通过南京云锦导购招募渠道注册开卡","YJ","开卡+入会","招募店铺","招募导购",null),
    /**
     * 南京云锦公众号链接开卡
     */
    YJ_CLUB_WECHATOFFICIALACCOUNTS("YJ-CLUB","公众号通过带参链接进入小程序记录南京云锦渠道来源","通过南京云锦线上渠道注册开卡","YJ","开卡+入会","默认店铺","默认导购","WeChatOfficialAccounts"),
    /**
     * VGRASS扫码开卡
     */
    VG_CLUB_1("VG-CLUB","门店扫码通过导购所属店铺归属VGRASS判断来源","通过VGRASS导购招募渠道注册开卡","VG","开卡+入会","招募店铺","招募导购",null),
    /**
     * VGRASS公众号链接开卡
     */
    VG_CLUB_WECHATOFFICIALACCOUNTS("VG-CLUB","公众号通过带参链接进入小程序记录VGRASS渠道来源","通过VGRASS线上渠道注册开卡","VG","开卡+入会","默认店铺","默认导购","WeChatOfficialAccounts"),
    /**
     * Teenie Weenie 女装扫码开卡
     */
    TW_CLUB_1("TW-CLUB","门店扫码通过导购查导购所属店铺ID前两位判断TW男、女、童归属关系","通过TW女装导购招募渠道注册开卡","TT","开卡+入会","招募店铺","招募导购",null),
    /**
     * Teenie Weenie 男装扫码开卡
     */
    TW_CLUB_2("TW-CLUB","门店扫码通过导购查导购所属店铺ID前两位判断TW男、女、童归属关系","通过TW男装导购招募渠道注册开卡","TN","开卡+入会","招募店铺","招募导购",null),
    /**
     * Teenie Weenie 童装扫码开卡
     */
    TW_CLUB_3("TW-CLUB","门店扫码通过导购查导购所属店铺ID前两位判断TW男、女、童归属关系","通过TW童装导购招募渠道注册开卡","TZ","开卡+入会","招募店铺","招募导购",null),
    /**
     * Teenie Weenie 公众号链接开卡
     */
    TW_CLUB_WECHATOFFICIALACCOUNTS("TW-CLUB","公众号通过带参链接进入小程序记录TW渠道来源","通过TW线上渠道注册开卡,例如微信公众号","TW","开卡+入会","默认店铺","默认导购","WeChatOfficialAccounts"),

    ;

    /**
     * 所属俱乐部 => 同品牌code
     */
    private String club;

    /**
     * 渠道记录方式
     */
    private String channelRecordMethod;

    /**
     * 来源
     */
    private String scene;

    /**
     * 卡号前缀
     */
    private String cardPrefix;

    /**
     * 身份
     */
    private String identity;

    /**
     * 开卡店铺
     */
    private String openStore;

    /**
     * 开卡导购
     */
    private String openGuide;

    /**
     * sourceWay
     */
    private String sourceWay;

    VGCardPrefixEnum(String club, String channelRecordMethod, String scene, String cardPrefix, String identity, String openStore, String openGuide, String sourceWay) {
        this.club = club;
        this.channelRecordMethod = channelRecordMethod;
        this.scene = scene;
        this.cardPrefix = cardPrefix;
        this.identity = identity;
        this.openStore = openStore;
        this.openGuide = openGuide;
        this.sourceWay = sourceWay;
    }

    public String getSourceWay() {
        return sourceWay;
    }

    public String getClub() {
        return club;
    }

    public String getCardPrefix() {
        return cardPrefix;
    }

    public static List<VGCardPrefixEnum> getAllWeChatOfficialAccounts(){
        ArrayList<VGCardPrefixEnum> vgCardPrefixEnums = new ArrayList<>();
        vgCardPrefixEnums.addAll(allWeChatOfficialAccounts);
        return vgCardPrefixEnums;
    }

    public static List<VGCardPrefixEnum> getApiOpenCardList() {
        ArrayList<VGCardPrefixEnum> vgCardPrefixEnums = new ArrayList<>();
        vgCardPrefixEnums.addAll(apiOpenCardList);
        return vgCardPrefixEnums;
    }

    private static List<VGCardPrefixEnum> allWeChatOfficialAccounts = new ArrayList<>();

    private static List<VGCardPrefixEnum> apiOpenCardList = new ArrayList<>();

    static {
        allWeChatOfficialAccounts.add(VGCardPrefixEnum.YJ_CLUB_WECHATOFFICIALACCOUNTS);
        allWeChatOfficialAccounts.add(VGCardPrefixEnum.VG_CLUB_WECHATOFFICIALACCOUNTS);
        allWeChatOfficialAccounts.add(VGCardPrefixEnum.TW_CLUB_WECHATOFFICIALACCOUNTS);

        apiOpenCardList.add(VGCardPrefixEnum.JH);
        apiOpenCardList.add(VGCardPrefixEnum.MALL_CLUB);
        apiOpenCardList.add(VGCardPrefixEnum.YJ_CLUB_WECHATOFFICIALACCOUNTS);
        apiOpenCardList.add(VGCardPrefixEnum.VG_CLUB_WECHATOFFICIALACCOUNTS);
        apiOpenCardList.add(VGCardPrefixEnum.TW_CLUB_WECHATOFFICIALACCOUNTS);
    }


}
