package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.vo.MembersSysVo;
import com.bizvane.members.facade.vo.taobao.TaoBaoMemberSysRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.Optional;

/**
 * @author houkai
 */
public interface MemberSysService {

    /**
     * 新建会员卡体系
     *
     * @param membersSysModel
     * @return
     * @throws MemberException
     */
    ResponseData addMemberSys(MembersSysModel membersSysModel) throws MemberException;

    /**
     * 根据品牌查询会员卡体系详情
     *
     * @param brandId
     * @return
     */
    ResponseData<MembersSysModel> queryMemberSysInfo(long brandId);

    /**
     * 编辑会员卡体系
     *
     * @param membersSysModel
     * @return
     * @throws MemberException
     */
    ResponseData updateMemberSys(MembersSysModel membersSysModel) throws MemberException;

    /**
     * 根据会员信息生成会员卡号
     *
     * @param memberInfoModel
     * @return
     */
    String produceCarNo(MemberInfoModel memberInfoModel);

    /**
     * 保存会员卡体系
     *
     * @param membersSysModel
     * @param currentUser
     * @return
     */
    ResponseData saveMemberSys(MembersSysModel membersSysModel, SysAccountPO currentUser);


    /**
     * 保存智慧门店会员体系
     */
    ResponseData<String> saveOrUpdateTaoBaoMemberSys(TaoBaoMemberSysRequestVo taoBao,Optional<SysAccountPO> optional);

    /**
     * 查询授权状态
     * @return
     */
    ResponseData<Integer> queryAuthState(Long brandId);


    /**
     * 查询会员卡体系详情
     * @param sysCompanyId
     * @param brandId
     * @return
     */
    ResponseData<MembersSysVo> queryMemberSysInfo(long sysCompanyId, long brandId);


    /**
     * 是否达到可以修改默认服务门店的最低条件
     * @param memberStoreId
     * @param sysCompanyId
     * @param brandId
     * @param memberCode
     * @return
     */
    boolean canUpdateServiceStore(Long memberStoreId, Long sysCompanyId, Long brandId,String memberCode);

    /**
     * 跨品牌查询适用门店是否可修改（现361使用）
     *
     * @param memberStoreId
     * @param sysCompanyId
     * @param brandId
     * @param memberCode
     * @return
     */
    boolean canUpdateServiceStoreForCompany(Long memberStoreId, Long sysCompanyId, Long brandId, String memberCode);
    /**
     * 查询会员卡体系是否开启默认服务门店变更开关
     * @param sysCompanyId
     * @param brandId
     * @return
     */
    boolean isEnableChangeMbrStore(long sysCompanyId, long brandId);

    /**
     * 查询会员所属服务门店是否是会员卡体系的默认虚拟门店
     * @param memberCode
     * @param serviceStoreId
     * @param sysCompanyId
     * @param brandId
     * @return
     */
    boolean isDefaultServiceStore(String memberCode, Long serviceStoreId, Long sysCompanyId, Long brandId);

    /**
     * 是否达到可以修改默认服务导购的最低条件
     *
     * @param serviceStoreId
     * @param serviceGuideId
     * @param sysCompanyId
     * @param brandId
     * @param memberCode
     * @return
     */
    boolean canUpdateServiceGuide(Long serviceStoreId, Long serviceGuideId, Long sysCompanyId, Long brandId, String memberCode);

    /**
     * 跨品牌查询适用门店下导购是否可修改（现361使用）
     *
     * @param serviceStoreId
     * @param serviceGuideId
     * @param sysCompanyId
     * @param brandId
     * @param memberCode
     * @return
     */
    boolean canUpdateServiceGuideForCompany(Long serviceStoreId, Long serviceGuideId, Long sysCompanyId, Long brandId, String memberCode);
}
