/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.service.datafetch.process;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFetchData<T, V> {
    private static final Logger log = LoggerFactory.getLogger(BaseFetchData.class);

    public final void dataFetch(String message, String topic) {
        log.info("enter MemberDataFetch messageBody:{} " + message);
        T t = this.messageToBean(message);
        ResponseData messageResponseData = this.verifyMessage(t, topic);
        if (SysResponseEnum.FAILED.getCode() == messageResponseData.getCode()) {
            return;
        }
        ResponseData<V> responseData = this.paramValidation(t, topic);
        if (SysResponseEnum.FAILED.getCode() == responseData.getCode()) {
            return;
        }
        Object newObj = responseData.getData();
        if (newObj == null) {
            return;
        }
        V original = this.messageIsExist(t);
        if (original == null) {
            this.insertData(newObj, topic);
        } else {
            this.updateData(newObj, original, topic);
        }
    }

    public abstract T messageToBean(String var1);

    public abstract ResponseData verifyMessage(T var1, String var2);

    public abstract ResponseData<V> paramValidation(T var1, String var2);

    public abstract V messageIsExist(T var1);

    public abstract int insertData(V var1, String var2);

    public abstract int updateData(V var1, V var2, String var3);
}

