package com.bizvane.fitmentservice.interfaces;


import com.bizvane.fitmentservice.models.po.AppletBrandMicroFitmentPo;
import com.bizvane.fitmentservice.models.vo.AppletBrandMicroFitmentReqVo;
import com.bizvane.fitmentservice.models.vo.AppletBrandMicroFitmentVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @author zcc
 * @date 2021/9/16 18:10
 **/
public interface AppletBrandMicroFitmentService {

    /**
     * 新增或者更新
     * @param appletBrandMicroFitmentPo
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> addOrUpdate(AppletBrandMicroFitmentPo appletBrandMicroFitmentPo, SysAccountPO sysAccountPO);

    /**
     * 获取微页面装修列表分页
     * @param appletBrandMicroFitmentReqVo
     * @return
     */
    ResponseData<PageInfo<AppletBrandMicroFitmentVo>> getPageByVo(AppletBrandMicroFitmentReqVo appletBrandMicroFitmentReqVo);

    /**
     * 删除
     * @param appletBrandMicroFitmentId
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> deleteById(Long appletBrandMicroFitmentId, SysAccountPO sysAccountPO);

    /**
     * 获取详情
     * @param appletBrandMicroFitmentId
     * @return
     */
    ResponseData<AppletBrandMicroFitmentVo> getById(Long appletBrandMicroFitmentId);
}
