package com.bizvane.fitmentservice.models.Rpc;

import com.bizvane.fitmentservice.models.bo.AppletBrandFunctionBo;
import com.bizvane.fitmentservice.models.bo.AppletBrandFunctionRpcBo;
import com.bizvane.fitmentservice.models.po.AppletBrandFunctionRelPO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.fitment.name}",path = "${feign.client.fitment.path}/memberMadeRpc")
public interface MenberMadeServiceRpc {
    /**
     * 根据品牌id获取功能菜单
     *
     * @param brandId
     * @return
     * */
    @RequestMapping(value = "/selectBrandFunctionRpc", method = RequestMethod.POST)
    ResponseData<List<AppletBrandFunctionRpcBo>> selectBrandFunctionRpc(@RequestParam("brandId") Long brandId,@RequestParam("choice") int choice);
    /**
     * 保存功能菜单
     *
     * @param appletBrandFunctionRelPo
     * @return
     * */
    @RequestMapping(value = "/insertBrandFunctionRpc", method = RequestMethod.POST)
    ResponseData<Long> insertBrandFunctionRpc(@RequestBody AppletBrandFunctionRelPO appletBrandFunctionRelPo);

    /**
     * 根据id功能菜单
     *
     * @param appletBrandFunctionRelId
     * @return
     * */
    @RequestMapping(value = "/selectByAppletBrandFunctionRelIdRpc", method = RequestMethod.POST)
    ResponseData<AppletBrandFunctionRelPO> selectByAppletBrandFunctionRelIdRpc(Long appletBrandFunctionRelId);

}
