/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.http;

import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    private final RestTemplate restTemplate;

    public RestTemplateUtils(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public <T> T sendRequest(HttpMethod method, String url, Object params, boolean isJsonBody, Class<T> clazz) {
        if (method == null || url == null || clazz == null) {
            throw new IllegalArgumentException("method, url, clazz must not be null");
        }
        HttpEntity requestEntity = null;
        if (method == HttpMethod.GET) {
            if (params != null && params instanceof Map) {
                Map paramMap = (Map)params;
                StringBuilder sb = new StringBuilder(url);
                if (!url.contains("?")) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                for (Map.Entry entry : paramMap.entrySet()) {
                    sb.append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
                }
                url = sb.deleteCharAt(sb.length() - 1).toString();
            }
        } else if (method == HttpMethod.POST) {
            HttpHeaders headers = new HttpHeaders();
            if (isJsonBody) {
                headers.setContentType(MediaType.APPLICATION_JSON);
                requestEntity = new HttpEntity(params, (MultiValueMap)headers);
            } else {
                LinkedMultiValueMap formData = new LinkedMultiValueMap();
                if (params != null && params instanceof Map) {
                    Map paramMap = (Map)params;
                    for (Map.Entry entry : paramMap.entrySet()) {
                        formData.add(entry.getKey(), entry.getValue());
                    }
                }
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                requestEntity = new HttpEntity((Object)formData, (MultiValueMap)headers);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported HTTP method: " + method);
        }
        ResponseEntity response = this.restTemplate.exchange(url, method, requestEntity, clazz, new Object[0]);
        return (T)response.getBody();
    }
}

