/*
 * Decompiled with CFR 0.152.
 */
package com.nascent.ecrp.opensdk.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger log = LoggerFactory.getLogger(SignUtils.class);

    public static String getSign(Map<String, Object> params, String secret) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString(params));
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder(secret);
        for (Object key : keys) {
            String value = jsonObject.getString((String)key);
            if (value == null || "".equals(value) || value.startsWith("[") || value.startsWith("{")) continue;
            query.append((String)key).append(value);
        }
        try {
            return SignUtils.encryptMD5(query.toString());
        }
        catch (IOException e) {
            log.error("MD5\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static String encryptMD5(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("utf-8"));
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
        return SignUtils.byte2hex(bytes);
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String temp = Integer.toHexString(b[n] & 0xFF);
            if (temp.length() == 1) {
                hs.append('0');
            }
            hs.append(temp);
        }
        return hs.toString().toUpperCase();
    }
}

