/*
 * Decompiled with CFR 0.152.
 */
package com.nascent.ecrp.opensdk.core.executeClient;

import com.alibaba.fastjson.JSON;
import com.nascent.ecrp.opensdk.core.executeClient.ApiClient;
import com.nascent.ecrp.opensdk.core.request.BaseRequest;
import com.nascent.ecrp.opensdk.core.request.IBaseRequest;
import com.nascent.ecrp.opensdk.core.response.BaseResponse;
import com.nascent.ecrp.opensdk.core.response.ExceptionResponse;
import com.nascent.ecrp.opensdk.core.util.HttpClientUtil;
import com.nascent.ecrp.opensdk.core.util.SignUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiClientImpl
implements ApiClient {
    private static final Logger log = LoggerFactory.getLogger(ApiClientImpl.class);
    private String serverUrl;
    private String appSecret;
    private Integer requestTimeOut;

    public ApiClientImpl(BaseRequest request) {
        this.serverUrl = request.getServerUrl();
        this.appSecret = request.getAppSecret();
        this.requestTimeOut = request.getRequestTimeOut();
    }

    @Override
    public <T extends BaseResponse> T execute(IBaseRequest<T> request) throws Exception {
        return this._execute(request);
    }

    private <T extends BaseResponse> T _execute(IBaseRequest<T> request) throws Exception {
        BaseResponse rsp;
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> superclass = request.getClass().getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            List<Field> superFieldList = Arrays.asList(superclass.getDeclaredFields());
            if (superFieldList == null || superFieldList.isEmpty()) continue;
            fieldList.addAll(superFieldList);
        }
        fieldList.addAll(Arrays.asList(request.getClass().getDeclaredFields()));
        for (Field field : fieldList) {
            field.setAccessible(true);
            params.put(field.getName(), field.get(request));
        }
        params.remove("serverUrl");
        params.remove("appSecret");
        params.put("nonce", System.currentTimeMillis());
        params.put("sign", SignUtils.getSign(params, this.appSecret));
        String body = "";
        String url = this.serverUrl + request.GetApiName();
        try {
            body = HttpClientUtil.postRequest(url, params, this.requestTimeOut);
            rsp = (BaseResponse)JSON.parseObject((String)body, request.getResponseClass());
            rsp.setBody(body);
            rsp.setParams(params);
        }
        catch (Exception e) {
            log.error("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u54cd\u5e94\u6570\u636e\uff1a" + body, (Throwable)e);
            rsp = new ExceptionResponse();
            rsp.setSuccess(false);
            rsp.setMsg("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38" + e);
            rsp.setCode("400");
        }
        return (T)rsp;
    }
}

