package com.bizvane.customized.facade.models.vo.shininghouse;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @author yy
 * @create 2019-03-11 17:14
 */
@Data
public class IntegralOrders implements Serializable {


    private Integer id;

    /**
     * 商户ID
     */
    private Integer merchantId;

    private String orderNo;

    private String memberCode;

    private String memberCardNo;

    private String memberName;

    private String memberPhone;

    private Integer goodId;

    private String goodNo;

    private String orderStatus;

    private Date orderTime;

    private String courierCompanyName;

    private String courierCompanyCode;

    private String courierNo;

    private Date sendGoodTime;

    private String couponNo;

    private String shippingName;

    private String shippingMobile;

    private String shippingProvince;

    private String shippingCity;

    private String shippingDistrict;

    private String shippingAddress;


    private String userComments;

    private String orderType;

    private Boolean valid;

    private Date gmtCreate;

    private Date gmtModified;

    private String staffName;

    private String storeName;

    private String goodName;

    private String orderStoreName;


    private String storeCode;


    private Integer storeId;


    private String isDeliverCheck;


    private String deliverAuditorMark;
    //==========================================================================================================

    private String showAddress;

    private String goodsName;

    private Integer price;


    private Integer saleQuantity;


    private Integer saleIntegral;

    private String beginTime;

    private String endTime;

    private String goodSkuNo;

    private String goodSkuSpecNames;

    private String levelName;


    private String shippingModeDetail;

    /**
     * 訂單明細列表
     */
    private List<IntegralOrdersDetails> ordersDetails;

    /**
     * 退货订单信息
     */
    private IntegralRefundOrder refundOrder;


    private Integer pageIndex;

    private Integer pageSize;


    private String orderTimeStr;


    private String searchForm;

    private IntegralGoods integralGoods;
    private IntegralGoodsSku integralGoodsSku;
    private String goodsSkuSpecNames;
    private Integer detailsId;
    private String coverImg;
    private String refundSort;
    private Integer totalIntegral;

    private Integer isAuditPass;//是否审核通过 1通过 0不通过


    public Integer getIsAuditPass() {
        return isAuditPass;
    }

    public void setIsAuditPass(Integer isAuditPass) {
        this.isAuditPass = isAuditPass;
    }

    public String getIsDeliverCheck() {
        return isDeliverCheck;
    }

    public void setIsDeliverCheck(String isDeliverCheck) {
        this.isDeliverCheck = isDeliverCheck;
    }

    public String getDeliverAuditorMark() {
        return deliverAuditorMark;
    }

    public void setDeliverAuditorMark(String deliverAuditorMark) {
        this.deliverAuditorMark = deliverAuditorMark;
    }

    public Integer getTotalIntegral() {
        return totalIntegral;
    }

    public void setTotalIntegral(Integer totalIntegral) {
        this.totalIntegral = totalIntegral;
    }

    public IntegralGoodsSku getIntegralGoodsSku() {
        return integralGoodsSku;
    }

    public void setIntegralGoodsSku(IntegralGoodsSku integralGoodsSku) {
        this.integralGoodsSku = integralGoodsSku;
    }

    public IntegralGoods getIntegralGoods() {
        return integralGoods;
    }

    public void setIntegralGoods(IntegralGoods integralGoods) {
        this.integralGoods = integralGoods;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Integer merchantId) {
        this.merchantId = merchantId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getMemberCardNo() {
        return memberCardNo;
    }

    public void setMemberCardNo(String memberCardNo) {
        this.memberCardNo = memberCardNo;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getMemberPhone() {
        return memberPhone;
    }

    public void setMemberPhone(String memberPhone) {
        this.memberPhone = memberPhone;
    }

    public Integer getGoodId() {
        return goodId;
    }

    public void setGoodId(Integer goodId) {
        this.goodId = goodId;
    }

    public String getGoodNo() {
        return goodNo;
    }

    public void setGoodNo(String goodNo) {
        this.goodNo = goodNo;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public String getCourierCompanyName() {
        return courierCompanyName;
    }

    public void setCourierCompanyName(String courierCompanyName) {
        this.courierCompanyName = courierCompanyName;
    }

    public String getCourierCompanyCode() {
        return courierCompanyCode;
    }

    public void setCourierCompanyCode(String courierCompanyCode) {
        this.courierCompanyCode = courierCompanyCode;
    }

    public String getCourierNo() {
        return courierNo;
    }

    public void setCourierNo(String courierNo) {
        this.courierNo = courierNo;
    }

    public Date getSendGoodTime() {
        return sendGoodTime;
    }

    public void setSendGoodTime(Date sendGoodTime) {
        this.sendGoodTime = sendGoodTime;
    }

    public String getCouponNo() {
        return couponNo;
    }

    public void setCouponNo(String couponNo) {
        this.couponNo = couponNo;
    }

    public String getShippingName() {
        return shippingName;
    }

    public void setShippingName(String shippingName) {
        this.shippingName = shippingName;
    }

    public String getShippingMobile() {
        return shippingMobile;
    }

    public void setShippingMobile(String shippingMobile) {
        this.shippingMobile = shippingMobile;
    }

    public String getShippingProvince() {
        return shippingProvince;
    }

    public void setShippingProvince(String shippingProvince) {
        this.shippingProvince = shippingProvince;
    }

    public String getShippingCity() {
        return shippingCity;
    }

    public void setShippingCity(String shippingCity) {
        this.shippingCity = shippingCity;
    }

    public String getShippingDistrict() {
        return shippingDistrict;
    }

    public void setShippingDistrict(String shippingDistrict) {
        this.shippingDistrict = shippingDistrict;
    }

    public String getShippingAddress() {
        return shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public String getUserComments() {
        return userComments;
    }

    public void setUserComments(String userComments) {
        this.userComments = userComments;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public Boolean getValid() {
        return valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate);
        setOrderTimeStr(time);
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Integer getSaleQuantity() {
        return saleQuantity;
    }

    public void setSaleQuantity(Integer saleQuantity) {
        this.saleQuantity = saleQuantity;
    }

    public Integer getSaleIntegral() {
        return saleIntegral;
    }

    public void setSaleIntegral(Integer saleIntegral) {
        this.saleIntegral = saleIntegral;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getGoodSkuNo() {
        return goodSkuNo;
    }

    public void setGoodSkuNo(String goodSkuNo) {
        this.goodSkuNo = goodSkuNo;
    }

    public String getGoodSkuSpecNames() {
        return goodSkuSpecNames;
    }

    public void setGoodSkuSpecNames(String goodSkuSpecNames) {
        this.goodSkuSpecNames = goodSkuSpecNames;
    }

    public List<IntegralOrdersDetails> getOrdersDetails() {
        return ordersDetails;
    }

    public void setOrdersDetails(List<IntegralOrdersDetails> ordersDetails) {
        this.ordersDetails = ordersDetails;
    }

    public IntegralRefundOrder getRefundOrder() {
        return refundOrder;
    }

    public void setRefundOrder(IntegralRefundOrder refundOrder) {
        this.refundOrder = refundOrder;
    }

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderTimeStr() {
        return orderTimeStr;
    }

    public void setOrderTimeStr(String orderTimeStr) {
        this.orderTimeStr = orderTimeStr;
    }

    public String getSearchForm() {
        return searchForm;
    }

    public void setSearchForm(String searchForm) {
        this.searchForm = searchForm;
    }

    public String getGoodsSkuSpecNames() {
        return goodsSkuSpecNames;
    }

    public void setGoodsSkuSpecNames(String goodsSkuSpecNames) {
        this.goodsSkuSpecNames = goodsSkuSpecNames;
    }

    public Integer getDetailsId() {
        return detailsId;
    }

    public void setDetailsId(Integer detailsId) {
        this.detailsId = detailsId;
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getRefundSort() {
        return refundSort;
    }

    public void setRefundSort(String refundSort) {
        this.refundSort = refundSort;
    }

    public String getShowAddress() {
        return showAddress;
    }

    public void setShowAddress(String showAddress) {
        this.showAddress = showAddress;
    }

    public String getGoodName() {
        return goodName;
    }

    public void setGoodName(String goodName) {
        this.goodName = goodName;
    }

    public String getOrderStoreName() {
        return orderStoreName;
    }

    public void setOrderStoreName(String orderStoreName) {
        this.orderStoreName = orderStoreName;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public Integer getStoreId() {
        return storeId;
    }

    public void setStoreId(Integer storeId) {
        this.storeId = storeId;
    }
}
